"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const electron_1 = require("electron");
const node_path_1 = __importDefault(require("node:path"));
let geometry = null;
try {
    const mod = require(node_path_1.default.join(__dirname, 'native', 'geometry', 'index.node'));
    if (mod) {
        geometry = {
            smoothPolyline: (points, intensity) => mod.smooth_polyline(points, Number(intensity) || 0),
            arrowHeadPoints: (from, to, headLen, headAngleDeg) => mod.arrow_head_points(from, to, Number(headLen) || 12, Number(headAngleDeg) || 28),
            rectFromPoints: (p1, p2) => mod.rect_from_points(p1, p2),
        };
    }
}
catch { }
electron_1.contextBridge.exposeInMainWorld('tt', {
    onKeyEvent: (handler) => electron_1.ipcRenderer.on('key-event', (_evt, payload) => handler?.(payload)),
    onMouseEvent: (handler) => electron_1.ipcRenderer.on('mouse-event', (_evt, payload) => handler?.(payload)),
    onMouseMove: (handler) => electron_1.ipcRenderer.on('mouse-move', (_evt, payload) => handler?.(payload)),
    onMouseVisible: (handler) => electron_1.ipcRenderer.on('mouse-visibility', (_evt, visible) => handler?.(visible)),
    onSettingsUpdated: (handler) => electron_1.ipcRenderer.on('settings-updated', (_evt, settings) => handler?.(settings)),
    onScreenshotCommand: (handler) => electron_1.ipcRenderer.on('screenshot-command', (_evt, payload) => handler?.(payload)),
    onRecordCommand: (handler) => electron_1.ipcRenderer.on('record-command', (_evt, payload) => handler?.(payload)),
    onPinnedShotsState: (handler) => electron_1.ipcRenderer.on('pinned-shots-state', (_evt, payload) => handler?.(payload)),
    onRefImagesState: (handler) => electron_1.ipcRenderer.on('ref-images-state', (_evt, payload) => handler?.(payload)),
    setDrawingCapture: (capture) => electron_1.ipcRenderer.send('draw-capture', !!capture),
    setOverlayFocusable: (focusable) => electron_1.ipcRenderer.send('overlay-focusable', !!focusable),
    focusOverlay: () => electron_1.ipcRenderer.send('overlay-focus'),
    pinShot: (payload) => electron_1.ipcRenderer.send('pin-shot-create', payload),
    startPinnedShotDrag: (payload) => electron_1.ipcRenderer.send('pin-shot-drag-start', payload),
    scalePinnedShot: (payload) => electron_1.ipcRenderer.send('pin-shot-scale', payload),
    removePinnedShot: (id) => electron_1.ipcRenderer.send('pin-shot-remove', { id }),
    popPinnedShot: () => electron_1.ipcRenderer.send('pin-shot-pop-last'),
    createRefImage: (payload) => electron_1.ipcRenderer.send('ref-image-create', payload),
    startRefImageDrag: (payload) => electron_1.ipcRenderer.send('ref-image-drag-start', payload),
    scaleRefImage: (payload) => electron_1.ipcRenderer.send('ref-image-scale', payload),
    rotateRefImage: (payload) => electron_1.ipcRenderer.send('ref-image-rotate', payload),
    setRefImageRect: (payload) => electron_1.ipcRenderer.send('ref-image-set-rect', payload),
    setRefImageProps: (payload) => electron_1.ipcRenderer.send('ref-image-set-props', payload),
    setRefImageDataUrl: (payload) => electron_1.ipcRenderer.send('ref-image-set-data-url', payload),
    resetRefImageProps: (id) => electron_1.ipcRenderer.send('ref-image-reset-props', { id }),
    duplicateRefImage: (payload) => electron_1.ipcRenderer.send('ref-image-duplicate', payload),
    removeRefImage: (id) => electron_1.ipcRenderer.send('ref-image-remove', { id }),
    setInteractiveRects: (rects) => electron_1.ipcRenderer.send('interactive-rects-updated', { rects }),
    setScreenshotPickMode: (active, opts) => {
        const o = (opts && typeof opts === 'object') ? opts : {};
        electron_1.ipcRenderer.send('screenshot-pick-mode', { active: !!active, displayId: o.displayId });
    },
    setRecordPickMode: (active, opts) => {
        const o = (opts && typeof opts === 'object') ? opts : {};
        electron_1.ipcRenderer.send('record-pick-mode', { active: !!active, displayId: o.displayId, capture: !!o.capture });
    },
    getSettings: () => electron_1.ipcRenderer.invoke('get-settings'),
    setSettings: (settings) => electron_1.ipcRenderer.invoke('set-settings', settings),
    resetSettings: () => electron_1.ipcRenderer.invoke('reset-settings'),
    closeSettings: () => electron_1.ipcRenderer.send('close-settings'),
    startSettingsDrag: (payload) => electron_1.ipcRenderer.send('settings-drag-start', payload),
    pickRefImages: () => electron_1.ipcRenderer.invoke('pick-ref-images'),
    getDesktopSourceId: async (opts) => {
        const { displayId } = (opts && typeof opts === 'object') ? opts : {};
        try {
            return await electron_1.ipcRenderer.invoke('desktop-source', { displayId });
        }
        catch {
            return { sourceId: '', error: 'desktop_source_failed' };
        }
    },
    captureScreen: async (opts) => {
        const { displayId } = (opts && typeof opts === 'object') ? opts : {};
        try {
            return await electron_1.ipcRenderer.invoke('screenshot-capture', { displayId });
        }
        catch {
            return { pngBase64: '', error: 'capture_failed' };
        }
    },
    captureAllDisplays: async () => {
        try {
            return await electron_1.ipcRenderer.invoke('capture-all-displays');
        }
        catch {
            return { displays: [], error: 'capture_failed' };
        }
    },
    saveScreenshot: (pngBase64, suggestedName) => electron_1.ipcRenderer.invoke('screenshot-save', { pngBase64, suggestedName }),
    copyScreenshot: async (pngBase64) => {
        try {
            const res = await electron_1.ipcRenderer.invoke('screenshot-clipboard', { pngBase64 });
            if (typeof res === 'boolean')
                return res ? { ok: true } : { ok: false, error: 'clipboard_write_failed' };
            return res;
        }
        catch {
            return { ok: false, error: 'clipboard_invoke_failed' };
        }
    },
    saveRecording: (data, opts) => {
        const o = (opts && typeof opts === 'object') ? opts : {};
        return electron_1.ipcRenderer.invoke('recording-save', { data, ext: o.ext, suggestedName: o.suggestedName });
    },
    exportRecording: (data, opts) => {
        const o = (opts && typeof opts === 'object') ? opts : {};
        return electron_1.ipcRenderer.invoke('recording-export', { data, fmt: o.fmt, crop: o.crop, scale: o.scale, fps: o.fps, suggestedName: o.suggestedName });
    },
    copyText: (text) => electron_1.ipcRenderer.invoke('copy-text', { text }),
    geometry,
});
//# sourceMappingURL=preload.js.map